#region References

using System;
using System.Diagnostics;
using System.IO;
using System.Text;
using System.Data;
using System.Collections;

#endregion

namespace gov.va.med.vbecs.DAL.HL7.OpenLibrary.Messages
{
	#region Header

	//<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	//<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	//<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	//<Developers>
	//	<Developer>David Askew</Developer>
	//</Developers>
	//<SiteName>Hines OIFO</SiteName>
	//<CreationDate>5/23/2008</CreationDate>
	//<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	//<summary>The HL7BtsMessage type represents the HL7 v2.5 Blood Product Dispense Status message. It implements the HL7ProtocolMessage type and is not meant to be inherited.</summary>

	#endregion 

	/// <summary>
	/// New class for BCE (CR 2962)
	/// </summary>
	public sealed class HL7BpsMessage : HL7ProtocolMessage
	{
		#region Variables

		/// <summary>
		/// Blood Product Dispense Status 
		/// </summary>
		private const string MESSAGE_TYPE = "BPS~O29";

		private const bool RESPONSE_REQUIRED_INDICATOR = true;

		private char[] _delimiters;

		private string[] _msh;
		private string[] _pid;
		private string[] _pv1;
		private string[] _orc;
		private string[] _bpo;
		private string[] _bpx;
		private string[] _obx;

		#endregion

		#region Constructors

		/// <summary>
		/// Empty static constructor added to get rid of "beforefieldinit" attribute generated by compiler.
		/// </summary>
		static HL7BpsMessage() {}

		///<Developers>
		///	<Developer>saic</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/23/2008</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8610"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>HL7BpsMessage</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="8611"> 
		///		<ExpectedInput>null</ExpectedInput>
		///		<ExpectedOutput>ArgumentNullException</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Constructor to load HL7 message.
		/// </summary>
		/// <param name="message">String representation of the HL7 message.</param>
		public HL7BpsMessage( string message )
			: base( message )
		{
			if( message == null )
				throw( new ArgumentNullException( "message" ) );
			//
			_message = message;
			//
			_messageControlID = HL7Utility.GetMessageControlID( message );
			//
			LoadDataFromHL7Message();
		}

		#endregion

		#region Public Methods

		///<Developers>
		///	<Developer>saic</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/23/2008</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8578"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="8579"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Returns the full HL7 message.
		/// </summary>
		/// <returns>string representation of HL7 message input.</returns>
		public override string GetMessage()
		{
			return Message;
		}

		///<Developers>
		///	<Developer>saic</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/23/2008</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8580"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="8581"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Returns the Message Control ID associated with this message
		/// </summary>
		/// <returns>Message Control ID in MSH segment</returns>
		public override string GetMessageControlID()
		{
			return MessageControlID;
		}

		///<Developers>
		///	<Developer>saic</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/23/2008</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8582"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="8583"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Overriden method to get the Message Type.
		/// </summary>
		/// <returns>Message Type, with Trigger Event, in MSH segment.</returns>
		public override string GetMessageType()
		{
			return MessageType;
		}

		///<Developers>
		///	<Developer>saic</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/23/2008</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8576"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>bool</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="8577"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// This method always returns true for this type of message.
		/// </summary>
		/// <returns>boolean</returns>
		public override bool IsResponseRequired()
		{
			return RESPONSE_REQUIRED_INDICATOR;
		}

		#endregion

		#region Protected Methods

		/// <summary>
		/// WriteHL7MessageBody
		/// </summary>
		/// <param name="writer"></param>
		protected override void WriteHL7MessageBody( StreamWriter writer )
		{
			if( writer == null )
			{
				throw( new ArgumentNullException( "writer" ) );
			}
			//
			writer.Write( this.Message );
		}

		#endregion

		#region Private Methods

		/// <summary>
		/// LoadDataFromHL7Message
		/// </summary>
		private void LoadDataFromHL7Message()
		{
			_delimiters = HL7Utility.ParseGetMessageDelimiters(this.Message);
			//
			string[] hl7Segments = HL7Utility.ParseGetAllMessageSegments( this.Message );
			//
			for (int i = 0 ; i < hl7Segments.Length - 1 ; i++ )
			{
				string[] seg = hl7Segments[i].Split(_delimiters[0]);
				//
				switch( seg[0] )
				{
					case "MSH":
						_msh = hl7Segments[i].Split(_delimiters[0]);						
						break;

					case "PID":
						_pid = hl7Segments[i].Split(_delimiters[0]);						
						break;

					case "PV1":
						_pv1 = hl7Segments[i].Split(_delimiters[0]);
						break;

					case "ORC":
						_orc = hl7Segments[i].Split(_delimiters[0]);
						break;

					case "BPO":
						_bpo = hl7Segments[i].Split(_delimiters[0]);
						break;

					case "BPX":
						_bpx = hl7Segments[i].Split(_delimiters[0]);
						break;

					case "OBX":
						_obx = hl7Segments[i].Split(_delimiters[0]);
						break;

					default:
						break;
				}
			}
		}

		#endregion

		#region Properties

		///<Developers>
		///	<Developer>saic</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/23/2008</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8598"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>byte array</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="8599"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Delimiters
		/// </summary>
		public char[] Delimiters
		{
			get
			{
				return _delimiters;
			}
		}

		///<Developers>
		///	<Developer>saic</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/23/2008</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8604"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="8605"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Full HL7 message
		/// </summary>
		public string Message
		{
			get
			{
				return _message;
			}
		}

		///<Developers>
		///	<Developer>saic</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/23/2008</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8602"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="8603"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Message Control ID
		/// </summary>
		public string MessageControlID
		{
			get
			{
				return _messageControlID;
			}
		}

		///<Developers>
		///	<Developer>saic</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/23/2008</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8606"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="8607"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// MessageType
		/// </summary>
		public string MessageType
		{
			get
			{
				return MESSAGE_TYPE;
			}
		}
		
		///<Developers>
		///	<Developer>saic</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/23/2008</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8596"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>string array</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="8597"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// MSH
		/// </summary>
		public string[] MSH
		{
			get
			{
				return _msh;
			}
		}

		///<Developers>
		///	<Developer>saic</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/23/2008</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8594"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>string array</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="8595"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// PID
		/// </summary>
		public string[] PID
		{
			get
			{
				return _pid;
			}
		}

		///<Developers>
		///	<Developer>saic</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/23/2008</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8592"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>string array</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="8593"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// PV1
		/// </summary>
		public string[] PV1
		{
			get
			{
				return _pv1;
			}
		}

		///<Developers>
		///	<Developer>saic</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/23/2008</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8590"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>string array</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="8591"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// ORC
		/// </summary>
		public string[] ORC
		{
			get
			{
				return _orc;
			}
		}

		///<Developers>
		///	<Developer>saic</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/23/2008</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8588"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>string array</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="8589"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// BPO
		/// </summary>
		public string[] BPO
		{
			get
			{
				return _bpo;
			}
		}

		///<Developers>
		///	<Developer>saic</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/23/2008</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8586"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>string array</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="8587"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// BPX
		/// </summary>
		public string[] BPX
		{
			get
			{
				return _bpx;
			}
		}

		///<Developers>
		///	<Developer>saic</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/23/2008</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8584"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>string array</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="8585"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// OBX
		/// </summary>
		public string[] OBX
		{
			get
			{
				return _obx;
			}
		}

		#endregion
	}
}
